<?php
/**
 * Fichier de fonction relative aux images
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 10-sep-06
 * {@source } 
 */

/**
 * Fonction permettant de générer une miniature de l'image passé en paramètre
 *
 * @param   String  l'url de l'image à modifier
 * @param   String  l'url de destination pour la miniature (optionnel)
 * @param   Integer La largeur voulue pour la miniature (optionnel)
 * @param   Integer La hauteur voulue pour la miniature (optionnel)
 * @return  String  L'url de la miniature, FALSE s'il y a une erreur
 */
function miniature($urlfile, $destination = DEFAULT_THUMBS, $width = DEFAULT_WIDTH, $height = DEFAULT_HEIGHT)
{
    //init the names
    $filename = strrchr($urlfile, "/");
    if (!$filename) {
        $filename = $urlfile;
    } else {
        $filename = substr($filename,1);
    }
    $position_extension = strrpos($filename, ".");
    if ($position_extension === false) {
        send_error("Error in the function 'miniature', the picture '".$urlfile."' hasn't extension.\n
                    Page:'".$_SERVER[ 'PHP_SELF' ]."'");
        return false;
    }
    $extension = substr($filename, $position_extension);
    $filename = substr($filename, 0, $position_extension);
    
    $dest_filename = $destination.$filename."-".$width."_".$height.$extension;
    
    //search if the file exist, if not create the file
    if (!file_exists(ROOT_FOLDER.$dest_filename)) {
        if (!fopen(ROOT_FOLDER.$dest_filename, "xb")) {
            send_error("Error in the function 'miniature', the picture '".$urlfile."' doesn't exist and faile to create.\n
                        Page:'".$_SERVER[ 'PHP_SELF' ]."'");
            return false;
        }
    }
    
    $image_src = imagecreatefromjpeg(ROOT_FOLDER.$urlfile);
    $image_dest = imagecreatetruecolor($width, $height);
    $width_src = imagesx($image_src);
	$height_src = imagesy($image_src);
	
    if (!imagecopyresampled($image_dest, $image_src, 0, 0, 0, 0, $width, $height, $width_src, $height_src)) {
        send_error("Error in the function 'miniature', the picture '".$urlfile."' isn't resized.\n
                    Page:'".$_SERVER[ 'PHP_SELF' ]."'");
        return false;
    }
    imagejpeg($image_dest,ROOT_FOLDER.$dest_filename);
    
    return $dest_filename;
}
?>