<?php
/**
 * Classe de gestion des releases des applications portables
 *
 * Cette classe permet de gérer tout ce qui concerne les releases des applications
 * portables dans leur généralité, c'est à dire le détails selon les versions des applications portables
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @package Winaptic
 * @access public
 * @version 1.0
 * @since 2006-09-09
 * {@source } 
 */
 
 
class WA_releases extends WA_apps
{
    public $idreleases;
    public $idlanguages;
    public $idbranch;
    public $date_release;
    public $changelog;
    public $changelog_url;
    public $releaser;
    public $releaser_email;
    public $notes;
    public $src_launcher_content;
    public $src_launcher_url;
    public $nb_download;
    public $subtitle;
    public $summary;
    public $content;
    public $comments;
    public $support_name;
    public $support_url;
    public $download_url;
    public $packed_file;
    public $packed_size;
    public $unpacked_size;
    public $fat_size;
    public $fat32_size;
    public $md5;
    public $screenshots;
    public $nb_screenshots;

	/**
	 * Constructeur de la classe, initiailise toutes les valeurs
	 */
    private function __construct()
    {
        new WA_apps();
        $this->idreleases            = 0;
        $this->idlanguages           = 1;
        $this->idbranch              = 1;
        $this->date_release          = "0000-00-00";
        $this->changelog             = "";
        $this->changelog_url         = "";
        $this->releaser              = "";
        $this->releaser_email        = "";
        $this->notes                 = "";
        $this->src_launcher_content  = "";
        $this->src_launcher_url      = "";
        $this->nb_download           = 0;
        $this->subtitle              = "";
        $this->summary               = "";
        $this->content               = "";
        $this->comments              = "";
        $this->support_name          = "";
        $this->support_url           = "";
        $this->download_url          = "";
        $this->packed_file           = 0;
        $this->packed_size           = 0;
        $this->unpacked_size         = 0;
        $this->fat_size              = 0;
        $this->fat32_size            = 0;
        $this->md5                   = "";
        $this->screenshots           = Array();
        $this->nb_screenshots        = 0;
    }
    
    
    /**
     * Fonction permettant de controler les répertoires
     * 
     * @return Boolean TRUE si l'arborescence est bonne, FALSE sinon
     */
    private function _releasesCheckFolder()
    {
        $dossier_global = $this->parent_name;
        $dossier_release = "r".$this->idreleases;
        $dossier_general = $this->name;
        $dossier_source = $this->name."src";
        $dossier_inc = $this->name."Inc";
        
        //vérification du dossier global
        $result = scan_folder(APP_FOLDER, $dossier_global);
        if (!$result) {
            send_error("Error in the function WA_releases->_releasesCheckFolder(), la création du dossier ".$dossier_global." a échoué");
            return false;
        }
        
        //vérification du dossier de la releases
        $result = scan_folder(APP_FOLDER."/".$dossier_global, $dossier_release);
        if (!$result) {
            send_error("Error in the function WA_releases->_releasesCheckFolder(), la création du dossier ".$dossier_release." a échoué");
            return false;
        }
        
        //vérification du dossier général
        $result = scan_folder(APP_FOLDER."/".$dossier_global."/".$dossier_release, $dossier_general);
        if (!$result) {
            send_error("Error in the function WA_releases->_releasesCheckFolder(), la création du dossier ".$dossier_general." a échoué");
            return false;
        }
        
        //vérification du dossier source
        $result = scan_folder(APP_FOLDER."/".$dossier_global."/".$dossier_release."/".$dossier_general, $dossier_source);
        if (!$result) {
            send_error("Error in the function WA_releases->_releasesCheckFolder(), la création du dossier ".$dossier_source." a échoué");
            return false;
        }
        
        //vérification du dossier include
        $result = scan_folder(APP_FOLDER."/".$dossier_global."/".$dossier_release."/".$dossier_general, $dossier_inc);
        if (!$result) {
            send_error("Error in the function WA_releases->_releasesCheckFolder(), la création du dossier ".$dossier_inc." a échoué");
            return false;
        }
        
        //retour
        return true;
    }
    
    
    /**
     * Fonction permettant de sauvegarder une release
     * 
     * @return Integer L'identifiant de la release, FALSE en cas d'erreur
     */
    public function releasesAdd()
    {
        if ($this->idreleases != 0) {
            send_error("Error in the function WA_releases->releasesAdd(), l'identifiant n'est pas null");
            return false;
        }
        
        $insert_releases = array("languages_idlanguages" => $this->idlanguages,
                                 "apps_idapps"           => $this->idapps,
                                 "branch_idbranch"       => $this->idbranch,
                                 "date_release"          => $this->date_release,
                                 "changelog"             => $this->changelog,
                                 "changelog_url"         => $this->changelog_url,
                                 "releaser"              => $this->releaser,
                                 "releaser_email"        => $this->releaser_email,
                                 "notes"                 => $this->notes,
                                 "src_launcher_content"  => $this->src_launcher_content,
                                 "src_launcher_url"      => $this->src_launcher_url,
                                 "nb_download"           => $this->nb_download,
                                 "subtitle"              => $this->subtitle,
                                 "summary"               => $this->summary,
                                 "content"               => $this->content,
                                 "comments"              => $this->comments,
                                 "support_name"          => $this->support_name,
                                 "support_url"           => $this->support_url,
                                 "download_url"          => $this->download_url,
                                 "packed_file"           => $this->packed_file,
                                 "packed_size"           => $this->packed_size,
                                 "unpacked_size"         => $this->unpacked_size,
                                 "fat_size"              => $this->fat_size,
                                 "fat32_size"            => $this->fat32_size,
                                 "md5"                   => $this->md5);
        $result = sql_insert("releases", $insert_releases);
        if ($result === false) {
            send_error("Error in the function WA_releases->releasesAdd(), l'insertion a généré une erreur");
            return false;
        }
        
        $this->idreleases = $result;
        return $result;
    }
    
    
    /**
     * Fonction permettant de mettre à jour la release
     * 
     * @return Boolean TRUE si la mise à jour s'est bien déroulé, FALSE sinon
     */
    public function releasesUpdate()
    {
        if ($this->idreleases == 0) {
            send_error("Error in the function WA_releases->releasesUpdate(), l'identifiant est null");
            return false;
        }
        
        $update_releases = array("languages_idlanguages" => $this->idlanguages,
                                 "apps_idapps"           => $this->idapps,
                                 "branch_idbranch"       => $this->idbranch,
                                 "date_release"          => $this->date_release,
                                 "changelog"             => $this->changelog,
                                 "changelog_url"         => $this->changelog_url,
                                 "releaser"              => $this->releaser,
                                 "releaser_email"        => $this->releaser_email,
                                 "notes"                 => $this->notes,
                                 "src_launcher_content"  => $this->src_launcher_content,
                                 "src_launcher_url"      => $this->src_launcher_url,
                                 "nb_download"           => $this->nb_download,
                                 "subtitle"              => $this->subtitle,
                                 "summary"               => $this->summary,
                                 "content"               => $this->content,
                                 "comments"              => $this->comments,
                                 "support_name"          => $this->support_name,
                                 "support_url"           => $this->support_url,
                                 "download_url"          => $this->download_url,
                                 "packed_file"           => $this->packed_file,
                                 "packed_size"           => $this->packed_size,
                                 "unpacked_size"         => $this->unpacked_size,
                                 "fat_size"              => $this->fat_size,
                                 "fat32_size"            => $this->fat32_size,
                                 "md5"                   => $this->md5);
        $result = sql_update("releases", $update_releases, "idreleases=".$this->idreleases);
        if ($result === false) {
            send_error("Error in the function WA_releases->releasesUpdate(), la mise à jour a généré une erreur");
            return false;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant de supprimer une release
     * 
     * @return Boolean TRUE si la release est bien supprimée, FALSE sinon
     * @todo Supprimer les screenshots physiquement du disque
     */
    public function releasesDelete()
    {
        if ($this->idreleases == 0) {
            send_error("Error in the function WA_releases->releasesDelete(), l'identifiant est null");
            return false;
        }
        
        //on supprime d'abord les screenshots
        $sql_query = "DELETE FROM releases_has_screenshots WHERE releases_idreleases=".$this->idreleases;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_releases->releasesDelete(), in the request: '".$sql_query."'
        		        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        //on supprime la release
        $sql_query = "DELETE FROM releases WHERE idreleases=".$this->idreleases;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_releases->releasesDelete(), in the request: '".$sql_query."'
        		        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant de mettre en mémoire la release
     * 
     * @param Integer $idreleases L'identifiant de la release à charger
     * @result Boolean TRUE si la release est bien chargée, FALSE sinon
     */
    public function releasesCharge($idreleases)
    {
        if ($idreleases <= 0) {
            send_error("Error in the function WA_releases->releasesCharge(), l'identifiant est null");
            return false;
        }
        
        $sql_query = "SELECT * 
                      FROM releases
                      WHERE idreleases=".$idreleases;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_releases->releasesCharge(), in the request: '".$sql_query."'
        		        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        if (mysql_num_rows($result) > 0) {
            $row = mysql_fetch_assoc($result);
            $this->idreleases            = $row["languages_idlanguages"];
            $this->idapps                = $row["apps_idapps"];
            $this->idbranch              = $row["branch_idbranch"];
            $this->date_release          = $row["date_release"];
            $this->changelog             = $row["changelog"];
            $this->changelog_url         = $row["changelog_url"];
            $this->releaser              = $row["releaser"];
            $this->releaser_email        = $row["releaser_email"];
            $this->notes                 = $row["notes"];
            $this->src_launcher_content  = $row["src_launcher_content"];
            $this->src_launcher_url      = $row["src_launcher_url"];
            $this->nb_download           = $row["nb_download"];
            $this->subtitle              = $row["subtitle"];
            $this->summary               = $row["summary"];
            $this->content               = $row["content"];
            $this->comments              = $row["comments"];
            $this->support_name          = $row["support_name"];
            $this->support_url           = $row["support_url"];
            $this->download_url          = $row["download_url"];
            $this->packed_file           = $row["packed_file"];
            $this->packed_size           = $row["packed_size"];
            $this->unpacked_size         = $row["unpacked_size"];
            $this->fat_size              = $row["fat_size"];
            $this->fat32_size            = $row["fat32_size"];
            $this->md5                   = $row["md5"];
            if ($row["apps_idapps"] > 0) {
                $this->appsCharge($row["apps_idapps"]);
            }
        } else {
            $this->idreleases            = 0;
            $this->idlanguages           = 1;
            $this->idbranch              = 1;
            $this->date_release          = "0000-00-00";
            $this->changelog             = "";
            $this->changelog_url         = "";
            $this->releaser              = "";
            $this->releaser_email        = "";
            $this->notes                 = "";
            $this->src_launcher_content  = "";
            $this->src_launcher_url      = "";
            $this->nb_download           = 0;
            $this->subtitle              = "";
            $this->summary               = "";
            $this->content               = "";
            $this->comments              = "";
            $this->support_name          = "";
            $this->support_url           = "";
            $this->download_url          = "";
            $this->packed_file           = 0;
            $this->packed_size           = 0;
            $this->unpacked_size         = 0;
            $this->fat_size              = 0;
            $this->fat32_size            = 0;
            $this->md5                   = "";
            $this->screenshots           = Array();
            $this->nb_screenshots        = 0;
        }
    }
    
    /**
     * Fonction permettant d'ajouter un screenshot à la release
     * 
     * @param Array $screenshots Le tableau contenant le screenshost
     * @param String $name Nom du screenshot
     * @return Boolean TRUE si l'ajout s'est bien déroulé, FALSE sinon
     */
    public function releasesAddScreenshots($screenshots, $name = "")
    {
        if ($this->idreleases == 0) {
            send_error("Error in the function WA_releases->releasesAddScreenshots(), l'identifiant est null");
            return false;
        }
        
        if (!$this->_releasesCheckFolder()) {
            send_error("Error in the function WA_releases->releasesAddScreenshots(), les dossiers n'existent pas");
            return false;
        }
        
        $num_scr = screenshots_name($this->idreleases);
        $name = $this->name."_screenshot".$num_scr;
        $name_small = $this->name."_screenshot_small".$num_scr;
        $folder = APP_FOLDER."/".$this->parent_name."/r".$this->idreleases."/".$this->name."/".$this->name."Inc";
        
        $name_original = upload($screenshots, $name, $folder);
        $name_small = screenshots_small($name, $folder);
        
        $insert_screenshots = array("name"         => $name,
                                    "small_url"    => $name_small,
                                    "original_url" => $name_original);
        $result = sql_insert("screenshots", $insert_screenshots);
        if ($result === false) {
            send_error("Error in the function WA_releases->releasesAddScreenshots(), l'insertion a généré une erreur");
            return false;
        }
        $idscreenshots = $result;
        
        $insert_relation = array("releases_idreleases"       => $this->idreleases,
                                 "screenshots_idscreenshots" => $idscreenshots);
        $result = sql_insert("releases_has_screenshots", $insert_relation, false);
        if ($result === false) {
            send_error("Error in the function WA_releases->releasesAddScreenshots(), l'insertion a généré une erreur");
            return false;
        }
        
        $this->screenshots[] = $idscreenshots;
        $this->nb_screenshots++;
        
        return true;
    }
    
    
    /**
     * Fonction permettant de suppimer un sreenshot à la release
     * 
     * @param Integer $idscreenshots L'identifiant du screenshot a supprimer
     * @return Boolean TRUE si le screenshota bien été supprimé, FALSE sinon
     */
    public function releasesDeleteScreenshots($idscreenshots)
    {
        if ($idscreenshots <= 0)
        {
            send_error("Error in the function WA_releases->releasesDeleteScreenshots(), l'identifiant est null");
            return false;
        }
        
        //suppression de la relation releases <-> screenshots
        $sql_query = "DELETE FROM releases_has_screenshots WHERE screenshots_idscreenshots=".$idscreenshots;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_releases->releasesDeleteScreenshots(), in the request: '".$sql_query."'
        		        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        //suppression du screenshots
        $sql_query = "DELETE FROM screenshots WHERE idscreenshots=".$idscreenshots;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_releases->releasesDeleteScreenshots(), in the request: '".$sql_query."'
        		        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        //suppression du screenshot dans le tableau
        $position = array_search($idscreenshots, $this->screenshots);
        if ($position === false) {
            return true;
        } else {
            unset($this->screenshots[$position]);
   	        sort($this->screenshots);
   	        $this->nb_screenshots--;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant d'avoir l'intitulé de la branche
     * 
     * @return String L'intitulé de la branche de la release
     */
    public function releasesBranch()
    {
        $return_value = gen_name("branch", $this->idbranch);
        
        return $return_value;
    }
    
    
    /**
     * Fonction permettant d'avoir l'intitulé du langage de la release
     * 
     * @return String L'intitulé du langage de la release
     */
    public function releasesLanguage()
    {
        $return_value = gen_name("languages", $this->idlanguages);
        
        return $return_value;
    }
}
?>