<?php
/**
 * Fichier permettant de créer et mettre à jour les applications portables
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version 1.0
 * @since 13-sep-06
 * {@source } 
 */

require_once "include/global_fns.php";
require_once "class/apps.class.php";

if (!connect_db()) {
    send_error("Erreur de connexion à la base de données.");
    exit();
}

//a-t-on validé le formulaire
if (isset($_POST["submit"]) && !empty($_POST["submit"])) {
    $apps = new WA_apps();
    if ($_POST["idapps"] != 0) {
        $apps->appsCharge($_POST["idapps"]);
    }
    foreach ($_POST as $key => $value) {
        $apps->$key = mysql_real_escape_string($value);
    }
    
    if ($apps->idapps == 0) {
        //nouvelle application portable
        $apps->appsAdd();
    } else {
        //mise à jour d'une application portable
        $apps->appsUpdate();
    }
    
    unset($apps);
}

$subst = array();
//ajout ou modification?
if (isset($_GET["idapps"]) && !empty($_GET["idapps"])) {
    $idapps = mysql_real_escape_string($_GET["idapps"]);
    $apps = new WA_apps();
    $apps->appsCharge($idapps);
} else {
    $apps = new WA_apps();
}
class_assoc($subst, $apps);

do_html_header("Liste des applications");
echo tpl_parse_file(TEMPLATE_FOLDER."apps_edit.html", $subst);
do_html_footer();
?>